/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Created by Andrew Wild - akohdr/2016
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// building upon https://www.shadertoy.com/view/4dX3zl
// looking to create terse cut/paste reuse (potentially minified) spacetime voxel viewer 
#define SPD_R 2.5
//#define SHOW_JETSETWILLY
#define SHOW_SPHERES
#define SHOW_AXIS
#define SHOW_QUADRANTS
#define SHOW_RINGS

// Cut/Paste begin ------------------------------------------------------------
#define BOB_H 7.
#define EYE_D 50.
#define B0 vec4(.0,.0,.0,1.)
#define B1 vec4(.6,.6,.6,1.)
#define B2 vec4(.3,.3,.3,1.)

// goal is fast voxel based abstraction returning existence and colour(c) in spacetime(P)
bool cVoxel(out vec4 c, const in vec4 P );

void VxViewer(out vec4 fc,        // fragColor
         const in vec2 P,         // fragCoord
         const in vec2 R,         // iResolution
         const in vec2 UV,        // texture uv
         const in float T ) {     // timebase

    float l = P.x / R.x - .5,
          sT = sin(T), cT = cos(T);

    vec3 r = vec3(l*cT - .8*sT, (P.y/R.y - .5)*R.y/R.x, .8*cT + l*sT),
         o = vec3(EYE_D*sT, BOB_H*sT, -EYE_D*cT),
         f = floor(o),
         q = sign(r),
         d = abs(length(r)/r),
         s = d*(q*(f-o) + (.5*q) + .5),
         m;
    
    for(int i=0;i<99;i++) {

        bvec3 a = lessThan(s.xyz,s.yzx),
              b = lessThanEqual(s.xyz,s.zxy);
        m = vec3(a.x && b.x, a.y && b.y, a.z && b.z);  //a && b

        if(cVoxel(fc,vec4(f.x,f.y,f.z,T))){ // move to top of loop for edgeless non-spin voxels
            fc += m.x>0. ? B0 : m.y>0. ? B1 : B2;
			return; // early exit
        }

        s += m*d;
        f += m*q;
    }
    fc = vec4(0.0);
}
// Cut/Paste end ------------------------------------------------------------

void main( void ) {

    VxViewer(gl_FragColor,
             gl_FragCoord.xy,
             iResolution.xy,
             gl_FragCoord.xy / iResolution.xy,  // uv
             SPD_R*iGlobalTime);          // timebase
}


// Test Geometry
const vec4 BLK = vec4(.0,.0,.0,1.),
           GRY = vec4(.3,.3,.3,1.),
           WHT = vec4(.6,.6,.6,1.),
#ifndef SHOW_JETSETWILLY
		   RED = vec4(.7,.0,.0,1.),
           GRN = vec4(.0,.7,.0,1.),
           BLU = vec4(.0,.0,.7,1.),
#endif
           YEL = vec4(.7,.7,.0,1.);

// hint of the power of a spacetime based abstraction
#ifdef SHOW_JETSETWILLY
	#define CB vec4(P.xyz,1.)/10.*sin(cos(20.*sin(T)))
	#define RED vec4(.7,.0,.0,1.)+CB
	#define GRN vec4(.0,.7,.0,1.)+CB
	#define BLU vec4(.0,.0,.7,1.)+CB
#endif


#define SPHERE(p,c,r) length(p.xyz-c)<r
#define VOXEL(p,c) SPHERE(p,c,0.5)
#define Q(q) if(q) return true;
#define QX(p,c) Q(VOXEL(p,c));
#define QS(C,P,X) {c=C+vec4(P.xyz,1.)/20.; Q(X)}
#define ineq(a,v,b) (a<v && v<b)
#define sq(a) a*a

bool cVoxel(out vec4 c,
       const in vec4 P ) {
    
    // TODO: scales O(n) with number tests
    //       use decorator for memoization of static geometry
    //       use distance field to cull 
    //       may need to pass view direction or light cone KISS
#ifdef SHOW_SPHERES
    float T = P.w;
    vec3 dynP = 9.*vec3(sin(T), cos(T), sq(sin(T)));
    c = RED;
    	Q(SPHERE(P, dynP.xyx, 3.3))
        QX(P,vec3(19.0,0.0,0.0))
    c = GRN;
    	Q(SPHERE(P, dynP.xyx, 3.3))
        QX(P,vec3(19.0,0.0,0.0))
    c = BLU;
    	Q(SPHERE(P, vec3(0.), dynP.z))
        QX(P,vec3(0.0,0.0,19.0))
#endif
            
#ifdef SHOW_AXIS
    c = GRY;
        vec4 a = abs(P);
        Q(a.y<.1 && a.z<.1 && ineq(0.,P.x,19.))
        Q(a.x<.1 && a.z<.1 && ineq(0.,P.y,19.))
        Q(a.x<.1 && a.y<.1 && ineq(0.,P.z,19.))
#endif

#ifdef SHOW_QUADRANTS
    c = YEL;
/* individual voxel comparisons slow but you can do it
        float D = 8.;
        QX(P,vec3( D, D, D))
        QX(P,vec3( D, D,-D))
        QX(P,vec3( D,-D, D))
        QX(P,vec3( D,-D,-D))
        QX(P,vec3(-D, D, D))
        QX(P,vec3(-D, D,-D))
        QX(P,vec3(-D,-D, D))
        QX(P,vec3(-D,-D,-D))
*/
    Q(length(abs(P.xyz)-vec3(8.))<1.)  // faster 
#endif
    
#ifdef SHOW_RINGS
    float L = length(P.xyz);
    c = WHT;
    c -= RED;
        Q(ineq(11.,L,12.) && cos(P.x)>.5)  // CSG 101
    c -= GRN;
        Q(ineq(8.,L,9.) && cos(P.z+3.14)>.5)
    c = YEL;
        Q(ineq(3.,L,6.) && cos(P.y+3.14)>.5)
#endif
    return false;
}



